/* tgl library
 * (c) 1999, Michel Beaudouin-Lafon, mbl@daimi.au.dk
 */

#ifndef _TGL_H_
#define _TGL_H_

#ifdef __cplusplus
extern "C" {
#endif

/* version */
#define TGL_VERSION_1_0		1

/* styles for tglDrawStyle */
#define TGL_NUMSTYLES	3
#define TGL_FILL	0
#define TGL_BORDER	1
#define TGL_SHADOW	2

/* modes for tglArrow */
#define TGL_ARROW_NONE	0
#define TGL_ARROW_START	1
#define TGL_ARROW_END	2
#define TGL_ARROW_BOTH	3

/* modes for tglBegin */
#define TGL_LINE_STRIP	1
#define TGL_LINE_LOOP	2
#define TGL_POLYGON	3

/* initialization */
extern void tglInit ();

/* state management */
extern void tglPushAttrib ();
extern void tglPopAttrib ();

/* state for all drawing functions */
extern void tglNumSlices (GLint n);
extern void tglDrawStyle (GLenum s);

/* state for Fill functions */
extern void tglBorder (GLdouble  b);
extern void tglFillColor3d (GLdouble r, GLdouble g, GLdouble b);
extern void tglFillColor4d (GLdouble r, GLdouble g, GLdouble b, GLdouble a);
extern void tglBorderColor3d (GLdouble r, GLdouble g, GLdouble b);
extern void tglBorderColor4d (GLdouble r, GLdouble g, GLdouble b, GLdouble a);
extern void tglThickness (GLdouble t);

/* state for Shadow functions */
extern void tglShadowColor3d (GLdouble r, GLdouble g, GLdouble b);
extern void tglShadowTransparency (GLdouble ain, GLdouble aout);
extern void tglShadowThickness (GLdouble in, GLdouble out);
extern void tglShadowOffset (GLdouble dx, GLdouble dy, GLdouble dz);
extern void tglShadowFill (GLboolean f);

/* state for Arrows */
extern void tglArrow (GLenum mode);
extern void tglArrowSize (GLdouble l, GLdouble w);

/* draw simple shapes and their borders */
extern void tglOval (GLdouble rx, GLdouble ry);
extern void tglRect (GLdouble w2, GLdouble h2);
extern void tglBegin (GLenum mode);
extern void tglVertex2d (GLdouble x, GLdouble y);
extern void tglEnd ();

#ifdef __cplusplus
}
#endif

/* _TGL_H_ */
#endif
