#include "lapi.h"
#include "hapi.h"
//#include <wingdi.h>

#define eSuspend 1
#define eUnSuspend 2
#define eCleanup 3

// This is hackish. Breaks with windows 95
#define SPI_GETMOUSESPEED 112

typedef struct MouseData {
	int X, Y;
	int dx, dy;
	int suspended;
	HBITMAP cachebitmap, cursorbitmap;
	int hx, hy, cx, cy; /* hotspot, old cache position */
	int tx, ty;
	int wx, wy, ww, wh;
	HDC cache, cursor;
	SIZE theSize; /* size of cursor */
} MouseData;

MouseData *micedata = NULL;
int nummice = -1;

HANDLE child = NULL;
volatile int mousecount;
volatile HWND mousewindow;
DWORD dwThreadId;
HANDLE datamutex = NULL;
HANDLE canvas = NULL;
HANDLE mutex = NULL;
HANDLE event = NULL;
HANDLE reply = NULL;

int lastsuspended, lastunsuspended, lastmoved;

unsigned int events;
volatile int call, parameter;

int accel[3];
int speed;
int rx, ry;

HDC tmp = NULL;

#ifdef HMONITOR
HMONITOR monitor = NULL;
MONITORINFO minfo;
#endif
int mleft, mright, mtop, mbottom;
HDC screen;

#define abs(x) (max((x),-(x)))

void __cdecl thehCallback(int number, signed int dx, signed int dy, unsigned int buttons, int suspended) {
	int x, y;
	x = y = 1;
	if (suspended)
		lastsuspended = number;
	else
		lastunsuspended = number;
	lastmoved = number;
	while (WaitForSingleObjectEx(datamutex, INFINITE, TRUE) != WAIT_OBJECT_0) ;
	if (events & ACCELERATE) {
		if (accel[2]) {
			if (abs(dx) > accel[0])
				x *= 2;
			if (abs(dy) > accel[0])
				y *= 2;
			if (accel[2] == 2) {
				if (abs(dx) > accel[1])
					x *= 2;
				if (abs(dy) > accel[1])
					y *= 2;
			}
		}
		dx *= x;
		dy *= y;

		if (speed >= 10) {
			dx *= (speed - 6); dy *= (speed - 6);
			dx += rx; dy += ry;
			rx = dx % 4; ry = ry % 4;
			dx /= 4; dy /= 4;
		} else {
			switch (speed) {
				case 0:
				case 1:
					dx += rx; dy += ry;
					rx = dx % 32; ry = dy % 32;
					dx /= 32; dy /= 32;
					break;
				case 2:
				case 3:
					dx += rx; dy += ry;
					rx = dx % 16; ry = dy % 16;
					dx /= 16; dy /= 16;
					break;
				case 4:
				case 5:
					dx += rx; dy += ry;
					rx = dx % 4; ry = dy % 4;
					dx /= 4; dy /= 4;
					break;
				case 6:
				case 7:
					dx += rx; dy += ry;
					rx = dx % 2; ry = dy % 2;
					dx /= 2; dy /= 2;
					break;
				case 8:
				case 9:
					dx *= 3; dy *= 3;
					dx += rx; dy += ry;
					rx = dx % 4; ry = dy % 4;
					dx /= 4; dy /= 4;
					break;
			}
		}
	}

	if ((number <= nummice) && (number > 0)) {
		micedata[number - 1].X += dx;
		micedata[number - 1].Y += dy;
		if (events & CLIP) {
			micedata[number - 1].X = max(mleft, min(mright, micedata[number - 1].X));
			micedata[number - 1].Y = max(mtop, min(mbottom, micedata[number - 1].Y));
		}
		micedata[number - 1].dx += dx;
		micedata[number - 1].dy += dy;
	}

	ReleaseMutex(datamutex);
	if (mousewindow != NULL) {
		WPARAM w = MAKEWPARAM(buttons, ((number & 0xff) << 8) | (((unsigned int) suspended) & 0xff));
		LPARAM l = MAKELPARAM(dx, dy);
		if (((l && (events & MOVEMENT)) || (buttons && (events & BUTTON))) &&
				((events & SUSPEND) || (!suspended)))
			PostMessage(mousewindow, WM_USER + 1001, w, l);
	}
	hUpdateCursors(TRUE);
}

void __cdecl hLockCanvas() {
	while (WaitForSingleObjectEx(canvas, INFINITE, TRUE) != WAIT_OBJECT_0) ;
}

void __cdecl hUpdateCursors(int useCache) {
	if (datamutex == NULL) return;
	if (events & CURSOR) {
		int i;
		while (WaitForSingleObjectEx(datamutex, INFINITE, TRUE) != WAIT_OBJECT_0) ;
		if (useCache) {
			if (WaitForSingleObjectEx(canvas, 0, TRUE) != WAIT_OBJECT_0) {
				ReleaseMutex(datamutex);
				return;
			}
		} else 
			while (WaitForSingleObjectEx(canvas, INFINITE, TRUE) != WAIT_OBJECT_0) ;
	
		// Backup background
		for (i = 0; i < nummice; ++i) {
			micedata[i].tx = micedata[i].X;
			micedata[i].ty = micedata[i].Y;
			if ((micedata[i].cursor)) {
				if (useCache) {
					micedata[i].wx = min(micedata[i].cx, micedata[i].tx) - micedata[i].hx;
					micedata[i].wy = min(micedata[i].cy, micedata[i].ty) - micedata[i].hy;
					micedata[i].ww = abs(micedata[i].cx - micedata[i].tx) + micedata[i].theSize.cx;
					micedata[i].wh = abs(micedata[i].cy - micedata[i].ty) + micedata[i].theSize.cy;
				} else {
					micedata[i].wx = micedata[i].tx - micedata[i].hx;
					micedata[i].wy = micedata[i].ty - micedata[i].hy;
					micedata[i].ww = micedata[i].theSize.cx;
					micedata[i].wh = micedata[i].theSize.cy;
				}
				BitBlt(tmp, micedata[i].wx, micedata[i].wy, micedata[i].ww, micedata[i].wh, screen, micedata[i].wx, micedata[i].wy, SRCCOPY);
			}
		}
		// Apply cache
		if (useCache)
		  for (i = 0; i < nummice; ++i)
		    BitBlt(tmp, micedata[i].cx - micedata[i].hx, micedata[i].cy - micedata[i].hy, micedata[i].theSize.cx, micedata[i].theSize.cy, micedata[i].cache, 0, 0, SRCCOPY);
		// Get new cache
		for (i = 0; i < nummice; ++i)
			BitBlt(micedata[i].cache, 0, 0, micedata[i].theSize.cx, micedata[i].theSize.cy, tmp, micedata[i].tx - micedata[i].hx, micedata[i].ty - micedata[i].hy, SRCCOPY);
		// MaskBlit in cursors
		for (i = 0; i < nummice; ++i) {
			if (!micedata[i].suspended) {
			  if (micedata[i].cursor)
			    TransparentBlt(tmp, micedata[i].tx - micedata[i].hx, micedata[i].ty - micedata[i].hy, micedata[i].theSize.cx, micedata[i].theSize.cy, micedata[i].cursor, 0, 0, micedata[i].theSize.cx, micedata[i].theSize.cy, RGB(255, 0, 205));
				BitBlt(screen, micedata[i].wx, micedata[i].wy, micedata[i].ww, micedata[i].wh, tmp, micedata[i].wx, micedata[i].wy, SRCCOPY);
				micedata[i].cx = micedata[i].tx;
				micedata[i].cy = micedata[i].ty;
			}
		}
		ReleaseMutex(canvas);
		ReleaseMutex(datamutex);
	}
}


DWORD WINAPI MainThread(LPVOID lpParameter) {
	int loop = TRUE;
	lRegisterCallback(thehCallback);
	parameter = lGetMice(mousecount);
	SetEvent(reply);
	while (loop) {
		if (WaitForSingleObjectEx(event, INFINITE, TRUE) == WAIT_OBJECT_0) {
			switch (call) {
				case eSuspend:
					lSuspendMouse(parameter);
					break;
				case eUnSuspend:
					lUnSuspendMouse(parameter);
					break;
				case eCleanup:
					lUnGetAllMice();
					lUnRegisterCallback();
					loop = FALSE;
				default: /* do nothing */;
			}
			ResetEvent(event);
			SetEvent(reply);
		}
#if 0
		hUpdateCursors(TRUE);
#endif
	}
	return 0;
}


// Not thread safe until after first call
int __cdecl hInitialise(int count, HWND window, HDC getscreen, unsigned int getevents) {
	int i;
	if (event == NULL) {
		event = CreateEvent(NULL, TRUE, FALSE, NULL);
		reply = CreateEvent(NULL, TRUE, FALSE, NULL);
	}
	if (datamutex == NULL) {
		datamutex = CreateMutex(NULL, TRUE, NULL);
	}
	if (mutex == NULL) {
		mutex = CreateMutex(NULL, TRUE, NULL);
		canvas = CreateMutex(NULL, FALSE, NULL);
	}
	if (child == NULL) {
		mousecount = count;
		mousewindow = window;
		child = CreateThread(NULL, 0, MainThread, NULL, 0, &dwThreadId);
	}
	if (child == NULL) {
		MessageBox(window, "Could not create mouse thread!", "Error!", MB_OK | MB_ICONEXCLAMATION);
		ReleaseMutex(mutex);
		return 0;
	}

	//	SetThreadPriority(child, THREAD_PRIORITY_HIGHEST);
	SetThreadPriority(child, 5);
	events = getevents;

	// Get acceleration information
	SystemParametersInfo(SPI_GETMOUSE, 0, accel, 0);
#ifdef SPI_GETMOUSESPEED
	SystemParametersInfo(SPI_GETMOUSESPEED, 0, &speed, 0);
#else
	speed = 10;
#endif
	rx = ry = 0;

	// Get monitor info
	if (events & CURSOR) {
		if (getscreen)
			screen = getscreen;
		else
			screen = CreateDC("DISPLAY", NULL, NULL, NULL);
#ifdef HMONITOR
		monitor = MonitorFromWindow(window, MONITOR_DEFAULTTOPRIMARY);
		minfo.cbSize = sizeof(MONITORINFO);
		GetMonitorInfo(monitor, &minfo);
		mleft = minfo.rcMonitor.left;
		mright = minfo.rcMonitor.right;
		mtop = minfo.rcMonitor.top;
		mbottom = minfo.rcMonitor.bottom;
#else
		mleft = 0;
		mtop = 0;
		mright = GetDeviceCaps(screen, HORZRES);
		mbottom = GetDeviceCaps(screen, VERTRES);
#endif
	} else
		events &= (~CLIP);

	while (WaitForSingleObjectEx(reply, INFINITE, TRUE) != WAIT_OBJECT_0) ;
	nummice = count = parameter;
	if (micedata != NULL) free(micedata);
	micedata = malloc(sizeof(MouseData) * nummice);
	for (i = 0; i < nummice; ++i) {
		micedata[i].X = micedata[i].Y = micedata[i].dx = micedata[i].dy =
			micedata[i].hx = micedata[i].hy = micedata[i].suspended = 0;
		micedata[i].cursor = 0;
		micedata[i].cache = 0;
	}
	ReleaseMutex(datamutex);
	ResetEvent(reply);
	ReleaseMutex(mutex);
	return count;
}

void __cdecl hSuspendMouse(int number) {
	if (mutex == NULL) return;
	while (WaitForSingleObjectEx(mutex, INFINITE, TRUE) != WAIT_OBJECT_0) ;
	lastsuspended = lastmoved = number;
	lastunsuspended = -1;
	if ((child != NULL) && (number <= nummice) && (number > 0)) {
		micedata[number - 1].suspended = 1;
		parameter = number;
		call = eSuspend;
		SetEvent(event);
		while (WaitForSingleObjectEx(reply, INFINITE, TRUE) != WAIT_OBJECT_0) ;
		ResetEvent(reply);
	}
	ReleaseMutex(mutex);
}

void __cdecl hUnSuspendMouse(int number) {
	if (mutex == NULL) return;
	lastunsuspended = lastmoved = number;
	lastsuspended = -1;
	while (WaitForSingleObjectEx(mutex, INFINITE, TRUE) != WAIT_OBJECT_0) ;
	if ((child != NULL) && (number <= nummice) && (number > 0)) {
		micedata[number - 1].suspended = 0;
		parameter = number;
		call = eUnSuspend;
		SetEvent(event);
		while (WaitForSingleObjectEx(reply, INFINITE, TRUE) != WAIT_OBJECT_0) ;
		ResetEvent(reply);
	}
	ReleaseMutex(mutex);
}

void __cdecl hCleanup(void) {
	if (mutex == NULL) return;
	while (WaitForSingleObjectEx(mutex, INFINITE, TRUE) != WAIT_OBJECT_0) ;
	if (child != NULL) {
		call = eCleanup;
		SetEvent(event);
		while (WaitForSingleObjectEx(reply, INFINITE, TRUE) != WAIT_OBJECT_0) ;
		ResetEvent(reply);
		/* TODO clean up cursors */
		CloseHandle(child); child = NULL;
	}
	ReleaseMutex(mutex);
}

void __cdecl hGetRelativePosition(int number, hPOINT* p) {
	if ((datamutex == NULL) || (p == NULL)) return;
	while (WaitForSingleObjectEx(datamutex, INFINITE, TRUE) != WAIT_OBJECT_0) ;
	if ((number <= nummice) && (number > 0)) {
		p->x = micedata[number - 1].dx;
		p->y = micedata[number - 1].dy;
		micedata[number - 1].dx -= p->x;
		micedata[number - 1].dy -= p->y;
	}
	ReleaseMutex(datamutex);
}

void __cdecl hGetAbsolutePosition(int number, hPOINT* p) {
	if ((datamutex == NULL) || (p == NULL)) return;
	while (WaitForSingleObjectEx(datamutex, INFINITE, TRUE) != WAIT_OBJECT_0) ;
	if ((number <= nummice) && (number > 0))
		p->x = micedata[number - 1].X;
	p->y = micedata[number - 1].Y;
	ReleaseMutex(datamutex);
}

void __cdecl hSetAbsolutePosition(int number, hPOINT p) {
	if (datamutex == NULL) return;
	while (WaitForSingleObjectEx(datamutex, INFINITE, TRUE) != WAIT_OBJECT_0) ;
	if ((number <= nummice) && (number > 0)) {
		micedata[number - 1].X = max(mleft, min(mright, p.x));
		micedata[number - 1].Y = max(mtop, min(mbottom, p.y));
	}
	ReleaseMutex(datamutex);
}

void __cdecl hSetCursor(int number, hPOINT p, HBITMAP cursor, BYTE r, BYTE g, BYTE b) {
	while (WaitForSingleObjectEx(datamutex, INFINITE, TRUE) != WAIT_OBJECT_0) ;
	if ((number <= nummice) && (number > 0)) {
		if (micedata[number - 1].cursor) {
			DeleteDC(micedata[number - 1].cursor);
			DeleteObject(micedata[number - 1].cursorbitmap);
			micedata[number - 1].cursor = NULL;
			micedata[number - 1].cursorbitmap = NULL;
			hUpdateCursors(TRUE);
			DeleteDC(micedata[number - 1].cache);
			DeleteObject(micedata[number - 1].cachebitmap);
			micedata[number - 1].cache = NULL;
			micedata[number - 1].cachebitmap = NULL;
		}
		micedata[number - 1].hx = p.x;
		micedata[number - 1].hy = p.y;
		if (cursor) {
			micedata[number - 1].cursor = CreateCompatibleDC(screen);
			micedata[number - 1].cache = CreateCompatibleDC(screen);
			if (tmp == NULL) {
				tmp = CreateCompatibleDC(screen);
				SelectObject(tmp, CreateCompatibleBitmap(screen, GetDeviceCaps(screen, HORZRES), GetDeviceCaps(screen, VERTRES)));
			}
			micedata[number - 1].theSize.cx = 18; // FIXME
			micedata[number - 1].theSize.cy = 18; // FIXME
			
			// FIXME: Memoryleak
			micedata[number - 1].cursorbitmap = CreateCompatibleBitmap(screen, micedata[number - 1].theSize.cx, micedata[number - 1].theSize.cy);
			micedata[number - 1].cachebitmap = CreateCompatibleBitmap(screen, micedata[number - 1].theSize.cx, micedata[number - 1].theSize.cy);

			SelectObject(micedata[number - 1].cursor, cursor);
			SelectObject(micedata[number - 1].cache, micedata[number - 1].cachebitmap);

			BitBlt(micedata[number - 1].cache, 0, 0, micedata[number - 1].theSize.cx, micedata[number - 1].theSize.cy, micedata[number - 1].cursor, 0, 0, SRCCOPY);
			SelectObject(micedata[number - 1].cursor, micedata[number - 1].cursorbitmap);

			FillRgn(micedata[number - 1].cursor, CreateRectRgn(0, 0, micedata[number - 1].theSize.cx, micedata[number - 1].theSize.cy), CreateSolidBrush(RGB(r, g, b)));
			TransparentBlt(micedata[number - 1].cursor, 0, 0, micedata[number - 1].theSize.cx, micedata[number - 1].theSize.cy, micedata[number - 1].cache, 0, 0, micedata[number - 1].theSize.cx, micedata[number - 1].theSize.cy, RGB(255, 0, 204));
			
			BitBlt(micedata[number - 1].cache, 0, 0, micedata[number - 1].theSize.cx, micedata[number - 1].theSize.cy, screen, 0, 0, WHITENESS);
			micedata[number - 1].cx = -10 - micedata[number - 1].theSize.cx - p.x;
			micedata[number - 1].cy = -10 - micedata[number - 1].theSize.cy - p.y;
		}
	}
	hUpdateCursors(TRUE);
	ReleaseMutex(datamutex);
}

int __cdecl hGetLastSuspended(void) {
	int i = lastsuspended;
	lastsuspended = -1;
	return i;
}

int __cdecl hGetLastUnSuspended(void) {
	int i = lastunsuspended;
	lastunsuspended = -1;
	return i;
}

int __cdecl hGetLastMoved(void) {
	int i = lastmoved;
	lastmoved = -1;
	return i;
}

