#include <png.h>
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include "betapng.h"

int ReadPNGalpha(char *name, HBITMAP *phbmp, void **pixels, int *width, int *height, HBITMAP *hmask)
{
  int result;
  BetaImage image;
  BetaImage mask;
  
  void *pBits = NULL;
  unsigned char *src;
  unsigned char *dst;
  unsigned char  r, g, b, a;
  int i;
  
  HBITMAP hBmp;


  
  result = BetaReadPNG(name, &image, 2);
  if(result != 0) {
    return result;
  }
  
  *width = image.width;
  *height = image.height;
  
  {
    BITMAPINFO bmp = { { sizeof(BITMAPINFOHEADER), image.width, image.height, 1, 32 } };
    hBmp = CreateDIBSection(NULL, & bmp, DIB_RGB_COLORS, & pBits, NULL, 0);

    src = (char *) image.data;
    dst = (char *) pBits;
    for(i = 0; i < image.width * image.height; i++) {
      r = src[0];
      g = src[1];
      b = src[2];
      a = src[3];
      dst[0] = b * a / 0xFF;
      dst[1] = g * a / 0xFF;
      dst[2] = r * a / 0xFF;
      dst[3] = a;
      src += 4;
      dst += 4;
    }
  }
  if(image.alpha) {
    betaImage2Mask(&image, &mask);
    *hmask = CreateBitmap(mask.width, mask.height, 1, 1, mask.data);
  }

  
  /* Return the bitmap */
  *phbmp = hBmp;
  *pixels = pBits;
  return 0;
}

void TransferRedPixels(unsigned char *src,
                       int srcrowbytes,
                       unsigned char *dst,
                       int dstrowbytes,
                       int x, int y,
                       int width, int height, int winwidth, int winheight)
{
  unsigned char *srcrow;
  unsigned char *dstrow;
  unsigned char *srcpixel;
  unsigned char *dstpixel;

  int xx;
  int yy;

  int a;
  
  int i;
  int j;

  
  yy = y;
  
  srcrow = src += srcrowbytes * (height - 1);
  dstrow = dst + (dstrowbytes * y) + 4 * x;
  
  for (i = 0; i < height; i++) {
    srcpixel = srcrow;
    dstpixel = dstrow;
    if(yy >= 0 && yy < winheight) {
      xx = x;
      for(j = 0; j < width; j++) {
        if (xx >= 0 && xx < winwidth) {
          a = srcpixel[3];
          dstpixel[0] = srcpixel[0] + ((255 - a) * dstpixel[0] / 0xFF);
          dstpixel[1] = srcpixel[1] + ((255 - a) * dstpixel[1] / 0xFF);
          dstpixel[2] = srcpixel[2] + ((255 - a) * dstpixel[2] / 0xFF);
        }
        srcpixel += 4;
        dstpixel += 4;
        xx++;
      }
    }
    yy++;
    srcrow -= srcrowbytes;
    dstrow += dstrowbytes;
  }
}

void write_pixels_to_png_area(HBITMAP hbmp, int x, int y, int width, int height, char *file_name)
{

  BITMAP bitmap;
  int result;

  FILE *fp;
  png_structp png_ptr;
  png_infop info_ptr;
  unsigned char **rows;
  unsigned char *image;
  long k; 
  png_color_8 sig_bit;
  
  unsigned char *data;
  unsigned char *line1;
  unsigned char *line2;
  

  result = GetObject((HGDIOBJ) hbmp, sizeof(BITMAP), (void *) &bitmap);
  
  if(!result) {
    return;
  }
  

  
  data = bitmap.bmBits;
  
  

  
  if(!data) {
    return;
  }
  fp = fopen(file_name, "wb");

  if(!fp) {
    return;
  }

  png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);

  if(!png_ptr) {
    fclose(fp);
    return;
  }

  info_ptr = png_create_info_struct(png_ptr);

  if(!info_ptr) {
    fclose(fp);
    png_destroy_write_struct(&png_ptr, NULL);
    return;
  }

  if(setjmp(png_ptr->jmpbuf)) {
    fclose(fp);
    png_destroy_write_struct(&png_ptr, NULL);
    return;
  }


  png_init_io(png_ptr, fp);
  png_set_IHDR(png_ptr, info_ptr, width, height, 8,
               PNG_COLOR_TYPE_RGB_ALPHA, PNG_INTERLACE_NONE,
               PNG_COMPRESSION_TYPE_BASE, PNG_FILTER_TYPE_BASE);

  png_write_info(png_ptr, info_ptr);
  png_set_bgr(png_ptr);

  {
    int i;
    int j;
    unsigned char *row;
    unsigned char *pixel;

    row = data + (bitmap.bmWidthBytes * y) + x*4;
    for(i = 0; i < height; i++) {
      pixel = row;
      for(j = 0; j < width; j++) {
        pixel[3] = 255;
        pixel += 4;
      }
      row += bitmap.bmWidthBytes;
    }
  }
    
  rows = (unsigned char **) malloc(height * sizeof(unsigned char *));
  image = data + (bitmap.bmWidthBytes * y) + x*4;
  for(k = 0; k < height; k++) {
    rows[k] = image;
    image += bitmap.bmWidthBytes;
  }

  png_write_image(png_ptr, rows);
  png_write_end(png_ptr, info_ptr);
  
  fclose(fp);
  free(rows);
  png_destroy_write_struct(&png_ptr, NULL);
  return;
}

void write_pixels_to_png_area_rgb(HBITMAP hbmp, int x, int y, int width, int height, char *file_name,
                                  int transparent, int t_red, int t_green, int t_blue)
{

  BITMAP bitmap;
  int result;

  FILE *fp;
  png_structp png_ptr;
  png_infop info_ptr;
  unsigned char **rows;
  unsigned char *image;
  long k; 
  png_color_8 sig_bit;

  png_color_16 t_color;
  
  
  unsigned char *data;
  unsigned char *line1;
  unsigned char *line2;
  

  result = GetObject((HGDIOBJ) hbmp, sizeof(BITMAP), (void *) &bitmap);
  
  if(!result) {
    return;
  }
  

  
  data = bitmap.bmBits;
  
  

  
  if(!data) {
    return;
  }
  fp = fopen(file_name, "wb");

  if(!fp) {
    return;
  }

  png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);

  if(!png_ptr) {
    fclose(fp);
    return;
  }

  info_ptr = png_create_info_struct(png_ptr);

  if(!info_ptr) {
    fclose(fp);
    png_destroy_write_struct(&png_ptr, NULL);
    return;
  }

  if(setjmp(png_ptr->jmpbuf)) {
    fclose(fp);
    png_destroy_write_struct(&png_ptr, NULL);
    return;
  }


  png_init_io(png_ptr, fp);
  png_set_compression_level(png_ptr, Z_BEST_COMPRESSION);
  
  png_set_IHDR(png_ptr, info_ptr, width, height, 8,
               PNG_COLOR_TYPE_RGB, PNG_INTERLACE_NONE,
               PNG_COMPRESSION_TYPE_BASE, PNG_FILTER_TYPE_BASE);

  if(transparent) {
    t_color.red = t_red;
    t_color.green = t_green;
    t_color.blue = t_blue;
    png_set_tRNS(png_ptr, info_ptr, NULL, 0, &t_color);
  }

  
  png_write_info(png_ptr, info_ptr);
  png_set_filler(png_ptr, 0, PNG_FILLER_AFTER);
  png_set_bgr(png_ptr);
  
  
  {
    int i;
    int j;
    unsigned char *row;
    unsigned char *pixel;

    row = data + (bitmap.bmWidthBytes * y) + x*4;
    for(i = 0; i < height; i++) {
      pixel = row;
      for(j = 0; j < width; j++) {
        pixel[3] = 255;
        pixel += 4;
      }
      row += bitmap.bmWidthBytes;
    }
  }
    
  rows = (unsigned char **) malloc(height * sizeof(unsigned char *));
  image = data + (bitmap.bmWidthBytes * y) + x*4;
  for(k = 0; k < height; k++) {
    rows[k] = image;
    image += bitmap.bmWidthBytes;
  }

  png_write_image(png_ptr, rows);
  png_write_end(png_ptr, info_ptr);
  
  fclose(fp);
  free(rows);
  png_destroy_write_struct(&png_ptr, NULL);
  return;
}



HBITMAP BetaCreateBitmap(HDC hdc, void **pixels, int width, int height)
{
  void *pBits = NULL;
  HBITMAP hBmp;
  {
    BITMAPINFO bmp = { { sizeof(BITMAPINFOHEADER), width, height, 1, 32 } };
    hBmp = CreateDIBSection(NULL, & bmp, DIB_RGB_COLORS, & pBits, NULL, 0);
  }
  *pixels = pBits;
  return hBmp;
}

