#ifdef nti
#include <windows.h>
#endif

#include <GL/gl.h>
#include <GL/glu.h>

#include <GL/glut.h>

#include <stdlib.h>
#include <stdio.h>

#define BUFSIZE 512

static int newModel = 1 ;
static int moving, beginx, beginy ;
static GLdouble anglex=0, angley=0 ;   /* in degrees */
static int selState=0 ;
static int selection = -1 ;

GLfloat VIEWSIZE = 5.0;

/* --------------------------------------------------------------------------------- */

extern void Module_Init(void) ;
extern void Module_Resize(int width, int height) ;
extern void Module_Draw(GLenum mode, int obj) ;
extern void Module_StartControl(int obj, int x, int y, GLdouble X, GLdouble Y) ;
extern void Module_Control(int obj, int x, int y, GLdouble X, GLdouble Y) ;
extern void Module_ControlKey(int obj, int d) ;
extern int Module_keyboardEvents(unsigned char key, int obj, int x, int y, GLdouble X, GLdouble Y) ;

/* --------------------------------------------------------------------------------- */

static void
reshapeEvents(int width, int height)
{
	Module_Resize (width, height);
}

static void
redisplayEvents(void)
{
	if (newModel) {
		glMatrixMode (GL_MODELVIEW) ;
		glPopMatrix();
		glPushMatrix();
		glRotated(anglex, 0.0, 1.0, 0.0);
		glRotated(angley, 1.0, 0.0, 0.0);
		newModel = 0;
	}

	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT) ;
	Module_Draw(GL_RENDER, selection) ;
	glutSwapBuffers() ;
}

static void
unProject (int x, int y, GLdouble* wx, GLdouble*wy)
{
	GLdouble wz;
	GLint viewport [4];
	GLdouble mvmatrix [16], projmatrix [16];
	
	glGetIntegerv(GL_VIEWPORT, viewport) ;
	glGetDoublev(GL_MODELVIEW_MATRIX, mvmatrix) ;
	glGetDoublev(GL_PROJECTION_MATRIX, projmatrix) ;
	if (gluUnProject ((GLdouble) x, (GLdouble) (viewport[3] - y), 0.0,
			  mvmatrix, projmatrix, viewport, wx, wy, &wz) == GL_FALSE)
		printf ("can't unproject! !\n");

/*	printf ("unproject %d %d -> %g %g\n", x, y, *wx, *wy);*/
}

static int
Hit (int x, int y)
{
	GLuint selectBuf[BUFSIZE] ;
	GLint hits ;
	GLint viewport[4] ;
	int selState = 0;
	int selection = -1;

	glSelectBuffer(BUFSIZE, selectBuf) ;
	glRenderMode (GL_SELECT) ;

	glInitNames() ;
	glPushName(-1) ;

	glMatrixMode (GL_PROJECTION) ;
	glPushMatrix () ;
	glLoadIdentity () ;
	glGetIntegerv(GL_VIEWPORT, viewport) ;
	/* create pixel picking region near cursor location */
	gluPickMatrix( (GLdouble) x, (GLdouble) (viewport[3] - y), 
			    5.0, 5.0, viewport ) ;
	glOrtho(-VIEWSIZE, VIEWSIZE, -VIEWSIZE, VIEWSIZE, -VIEWSIZE, VIEWSIZE) ;
	Module_Draw(GL_SELECT, selection) ;
	glMatrixMode (GL_PROJECTION) ;
	glPopMatrix () ;

    
	hits = glRenderMode(GL_RENDER) ;
	if (hits) {
		GLuint *ptr = (GLuint*) selectBuf;
		int i;
		GLfloat zmax = 0.0;
		for (i = 0; i < hits; i++) {
			int numnames = *ptr++;
			GLfloat z1 = (float) *ptr++ / 0x7fffffff;
			GLfloat z2 = (float) *ptr++ / 0x7fffffff;
			ptr += numnames;
/*    			printf ("[%g-%g] %d\n", z1, z2, *(ptr-1));*/
			if (selState == 0 || z2 > zmax) {
				selState = 1;
				selection = *(ptr-1);
				zmax = z2;
			}
		}
	}
	
	return selection;
}

static void
mouseButtonEvents(int button, int state, int x, int y)
{
	/* use middle button to orient the model, or ctrl-left button (for the Mac) */
	if (button == GLUT_MIDDLE_BUTTON || (button == GLUT_LEFT_BUTTON && glutGetModifiers() == GLUT_ACTIVE_CTRL)) {
		if (state == GLUT_DOWN) {
			moving = 1;
			beginx = x;
			beginy = y;
		} else
			moving = 0;
		glutPostRedisplay ();
		return;
	}
	
	if (button==GLUT_LEFT_BUTTON && glutGetModifiers() != GLUT_ACTIVE_CTRL && state==GLUT_UP) {
		selection = -1;
		glutPostRedisplay ();
		return;
	}
  
	if (button==GLUT_LEFT_BUTTON && glutGetModifiers() != GLUT_ACTIVE_CTRL && state==GLUT_DOWN) {
		selection = Hit (x, y);
		selState = 0;
		if (selection >= 0) {
			GLdouble X, Y;
			selState = 1;
			unProject (x, y, &X, &Y);
			Module_StartControl (selection, x, y, X, Y);
			glutPostRedisplay() ;
		}
    
	}
}

static void
mouseMotionEvents(int x, int y)
{
	if (moving) {
		anglex = anglex + (x - beginx);
		beginx = x;
		angley = angley + (y - beginy);
		beginy = y;

		newModel = 1;
		glutPostRedisplay();
		return ;
	}
	if (selState) {
		GLdouble X, Y;
		unProject (x, y, &X, &Y);
		Module_Control(selection, x, y, X, Y) ;
	}
}

static void
keyboardEvents(unsigned char key, int x, int y)
{
	int selection = -1;
	GLdouble X, Y;
	
	selection = Hit (x, y);
	unProject (x, y, &X, &Y);
	if (Module_keyboardEvents(key, selection, x, y, X, Y)) {
		glutPostRedisplay ();
		return ;
	}

	switch (key) {
		case '0':
			Module_ControlKey(selection, 0);
			break;
		case '+':
			Module_ControlKey(selection, 1);
			break;
		case '-':
			Module_ControlKey(selection, -1);
			break;
		case ' ': /* space */
			selection = 0;
			break ;
		case '.': /* 0 */
			anglex = angley = 0 ;
			newModel = 1 ;
		break ;
			case 27: /* Esc */
			exit(0) ;
		default:
			printf("%d\n",key) ;
	}
	glutPostRedisplay() ;
}

/* --------------------------------------------------------------------------------- */

void
main(int argc, char** argv)
{
	glutInit(&argc, argv) ;

	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH) ;

	glutInitWindowSize(500, 500) ;
	glutInitWindowPosition (100, 100) ;
	glutCreateWindow ("Shadows") ;

	glutReshapeFunc(reshapeEvents) ;
	glutDisplayFunc(redisplayEvents);
	glutMouseFunc(mouseButtonEvents) ; 
	glutMotionFunc(mouseMotionEvents) ;
	glutKeyboardFunc(keyboardEvents) ;

	Module_Init() ;
	glEnable(GL_DEPTH_TEST) ;
/*	glutFullScreen() ;*/
	glutMainLoop() ;
}
