
#include <stdlib.h>

extern long IOAtoAOAtreshold;

typedef struct _group_header
{
  struct _group_header  *data_start;
  long                  *protoTable;
  struct _group_header  *data_end;
  long                   code_start;
  long                   code_end;
  char                  *group_name;
  struct _{
    unsigned long        hash;
    unsigned long        modtime;
  } unique_group_id;
  struct _group_header **ptr; /* pointer back to beta_data file */
} group_header;



extern group_header* NextGroup (group_header* current);


long _betadatasize(void)
{
  long size = 0;
  group_header *current;
  char *start;
  char *end;
  

  current = NextGroup(NULL);
  while(current) {
    start = (char *) current->data_start;
    end = (char *) current->data_end;
    size += end - start;
    current = NextGroup(current);
  }
  return size;
}

long _betacodesize(void)
{
  long size = 0;
  group_header *current;
  char *start;
  char *end;
  

  current = NextGroup(NULL);
  while(current) {
    start = (char *) current->code_start;
    end = (char *) current->code_end;
    size += end - start;
    current = NextGroup(current);
  }
  return size;
}

void setIOAtoAOAtreshold(void)
{
  IOAtoAOAtreshold = 1;
  return;
}
