#ifndef __glft__
#define __glft__

//#define __luminance_alpha__

struct glft_font;

int
glft_get_ascent(const struct glft_font *);

int
glft_get_descent(const struct glft_font *);

int
glft_get_line_gap(const struct glft_font *);


struct glft_glyph;


struct glft_font*
glft_get_font(struct glft_glyph*);

int
glft_get_xadvance(const struct glft_glyph *);

void
glft_get_bounding_box(const struct glft_glyph *, int* xmin, int* ymin, int* xmax, int* ymax);


struct glft_pixmap_glyph;

struct glft_font*
glft_get_font(struct glft_glyph*);

int
glft_get_pixmap_glyph_xadvance(const struct glft_pixmap_glyph *);

void
glft_get_pixmap_glyph_bounding_box(const struct glft_pixmap_glyph *, int* xmin, int* ymin, int* xmax, int* ymax);

/* debug */
char*
glft_get_pixmap_glyph_pixmap(const struct glft_pixmap_glyph *);
/* debug */


struct glft_pixmap_texture;

int
glft_get_pixmap_texture_width(struct glft_pixmap_texture*);

int
glft_get_pixmap_texture_height(struct glft_pixmap_texture*);

char*
glft_get_pixmap_texture_pixmap(struct glft_pixmap_texture*);


extern int glft_ft_error;
extern int glft_gl_error;

int
glft_init(void);

int
glft_done(void);

struct glft_font*
glft_new_font(const char* file);

void
glft_delete_font(struct glft_font* thefont);

struct glft_glyph*
glft_new_glyph(struct glft_font* thefont, char thechar, int size);

void
glft_delete_glyph(struct glft_glyph* theglyph);

struct glft_pixmap_glyph*
glft_new_pixmap_glyph(struct glft_font* thefont, char thechar, int size);

void
glft_delete_pixmap_glyph(struct glft_pixmap_glyph* theglyph);


struct glft_pixmap_texture*
glft_new_pixmap_texture(struct glft_font*, const char* charset, int size);

void
glft_delete_pixmap_texture(struct glft_pixmap_texture*);

void
glft_glyph_render_plain(const struct glft_glyph* theglyph);

void
glft_glyph_render_outline(const struct glft_glyph* theglyph);

void
glft_pixmap_glyph_render(struct glft_pixmap_glyph* theglyph);

/* debug */
void
glft_pixmap_texture_render_texture(struct glft_pixmap_texture*);
/* debug */

void
glft_pixmap_texture_render(struct glft_pixmap_texture*, const char*);


#endif /* __glft__ */

