/*
 * Decompiled with CFR 0.152.
 */
package daimi.util;

import daimi.ui.betaeditor.BetaEditor;
import java.util.LinkedList;
import java.util.Stack;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class ReaderWriter {
    private static ReaderWriter rw = new ReaderWriter();
    private final int MAX = 256;
    private byte head = 0;
    private byte tail = 0;
    private byte size = 0;
    private byte[] read;
    private LinkedList writer = new LinkedList();
    private IDocument theDoc = null;
    private BetaEditor theEditor = null;
    private String title = null;
    private boolean dll = true;
    public Stack forward;
    public Stack back;

    private ReaderWriter() {
        this.read = new byte[256];
        this.forward = new Stack();
        this.back = new Stack();
    }

    public static synchronized ReaderWriter getRW() {
        return rw;
    }

    public synchronized void errors(Object[] errors) {
    }

    public synchronized void setDoc(IDocument theDoc) {
        this.theDoc = theDoc;
    }

    public synchronized void setEditor(BetaEditor theEditor) {
        this.theEditor = theEditor;
    }

    public synchronized void setTitle(String title) {
        this.title = title;
    }

    public synchronized void insertString(String output) {
        this.writer.addLast(output);
    }

    public synchronized void toReader(byte input) {
        if (this.size < 256) {
            byte by;
            this.read[this.head] = input;
            this.size = (byte)(this.size + 1);
            if (this.head == 255) {
                by = 0;
            } else {
                byte by2 = this.head;
                by = by2;
                this.head = (byte)(by2 + 1);
            }
            this.head = by;
        }
    }

    public synchronized boolean readerEmpty() {
        return this.size == 0;
    }

    public synchronized boolean writerEmpty() {
        return this.writer.isEmpty();
    }

    public synchronized byte getInput() {
        if (this.size > 0) {
            byte by;
            byte b = this.read[this.tail];
            this.size = (byte)(this.size - 1);
            if (this.tail == 255) {
                by = 0;
            } else {
                byte by2 = this.tail;
                by = by2;
                this.tail = (byte)(by2 + 1);
            }
            this.tail = by;
            return b;
        }
        return -1;
    }

    public synchronized void write() {
        if (!this.writer.isEmpty()) {
            this.out((String)this.writer.removeFirst());
        }
    }

    private synchronized void out(String line) {
        try {
            this.theDoc.replace(this.theDoc.getLength(), 0, line);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            System.out.println("Output error");
        }
    }

    public boolean Dll() {
        return this.dll;
    }

    public void setDll(boolean dll) {
        this.dll = dll;
    }
}

