/*
 * Decompiled with CFR 0.152.
 */
package daimi.util;

import daimi.ui.betaeditor.BetaEditor;
import daimi.util.ReaderWriter;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.jface.text.IDocument;

public class CompileThread
extends Thread {
    private IDocument output;
    private String name = null;
    private Process proc;
    private String line;
    private BetaEditor theEditor;

    public CompileThread(String name, IDocument output, BetaEditor theEditor) {
        this.setDaemon(true);
        this.name = name;
        this.output = output;
        this.theEditor = theEditor;
    }

    public void destroy() {
        if (this.proc != null) {
            this.proc.destroy();
        }
    }

    public void run() {
        try {
            String[] cmds = new String[]{"jbeta", this.name};
            this.proc = Runtime.getRuntime().exec(cmds);
            InputStream is = this.proc.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((this.line = br.readLine()) != null) {
                ReaderWriter.getRW().insertString(String.valueOf(this.line) + '\n');
                try {
                    this.output.replace(this.output.getLength(), 0, String.valueOf(this.line) + "\n");
                }
                catch (Exception exception) {}
            }
            br.close();
            isr.close();
            is.close();
            this.theEditor.ParseAndMarkOutput(this.output);
        }
        catch (Exception e) {
            System.out.println("Error in Run: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

