/*
 * Decompiled with CFR 0.152.
 */
package daimi.util;

import java.util.Stack;
import org.eclipse.jface.text.IDocument;

public class CompileOutputParser {
    private int fLineNo;
    private String fFilename;
    private String fMessage;
    private Stack lineNoStack = new Stack();
    private Stack fileStack = new Stack();
    private Stack messageStack = new Stack();

    public void parse(IDocument doc) {
        int off;
        String lines;
        int lineNo;
        int offset;
        int position = 0;
        boolean done = false;
        String contents = doc.get();
        while (!done) {
            offset = contents.indexOf("\n# *", position);
            if (offset > 0) {
                try {
                    lineNo = doc.getLineOfOffset(offset + 1);
                    lines = contents.substring(doc.getLineLength(lineNo) + offset + 4, 1 + offset + doc.getLineLength(lineNo) + doc.getLineLength(lineNo + 1) + doc.getLineLength(lineNo + 2));
                    off = lines.indexOf("\n");
                    int off2 = lines.indexOf("\"", off + 8);
                    this.messageStack.push(lines.substring(0, off));
                    this.fileStack.push(lines.substring(off + 8, off2));
                    this.lineNoStack.push(lines.substring(off2 + 8, lines.length() - 1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                position = offset + 1;
                continue;
            }
            done = true;
        }
        position = 0;
        done = false;
        boolean filenamefound = false;
        String filename = "";
        while (!done) {
            offset = contents.indexOf("\n*****", position);
            if (offset > 0) {
                try {
                    lineNo = doc.getLineOfOffset(offset + 1);
                    lines = contents.substring(offset + 7, doc.getLineLength(lineNo) + doc.getLineLength(lineNo + 1) + offset + 1);
                    off = lines.indexOf("\n");
                    this.messageStack.push(lines.substring(0, off));
                    this.lineNoStack.push(lines.substring(off + 13, lines.indexOf(";", off)));
                    if (!filenamefound) {
                        off = contents.indexOf("\n**** ");
                        lineNo = doc.getLineOfOffset(off + 1);
                        filename = String.valueOf(contents.substring((off += doc.getLineLength(lineNo) + doc.getLineLength(lineNo + 1)) + 2, off + doc.getLineLength(lineNo + 2))) + ".bet";
                        filenamefound = true;
                    }
                    this.fileStack.push(filename);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                position = offset + 1;
                continue;
            }
            done = true;
        }
    }

    public boolean hasMoreErrors() {
        return !this.fileStack.isEmpty();
    }

    public void getNext() {
        if (this.hasMoreErrors()) {
            this.fFilename = (String)this.fileStack.pop();
            this.fMessage = (String)this.messageStack.pop();
            this.fLineNo = new Integer((String)this.lineNoStack.pop());
        }
    }

    public String getFilename() {
        return this.fFilename;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public int getLineNo() {
        return this.fLineNo;
    }
}

