/*
 * Decompiled with CFR 0.152.
 */
package daimi.util;

import daimi.util.BetaColorProvider;
import daimi.util.BetaWhitespaceDetector;
import daimi.util.BetaWordDetector;
import java.util.ArrayList;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class BetaCodeScanner
extends RuleBasedScanner {
    private static String[] fgKeywords = new String[]{"body", "origin", "include", "inner", "enter", "do", "else", "exit", "for", "if", "this", "then", "build", "linkopt", "mdbody"};
    private static String[] fgTypes = new String[]{"boolean", "char", "byte", "short", "integer", "long", "float", "double", "text", "object"};
    private static String[] fgConstants = new String[]{"false", "none", "true"};
    private TextAttribute fComment;
    private TextAttribute fKeyword;
    private TextAttribute fType;
    private TextAttribute fString;
    private BetaColorProvider fColorProvider;

    public BetaCodeScanner(BetaColorProvider provider) {
        Token keyword = new Token((Object)new TextAttribute(provider.getColor(BetaColorProvider.KEYWORD)));
        Token type = new Token((Object)new TextAttribute(provider.getColor(BetaColorProvider.TYPE)));
        Token string = new Token((Object)new TextAttribute(provider.getColor(BetaColorProvider.STRING)));
        new Token((Object)new TextAttribute(provider.getColor(BetaColorProvider.COMMENT)));
        Token other = new Token((Object)new TextAttribute(provider.getColor(BetaColorProvider.DEFAULT)));
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\\'));
        rules.add(new SingleLineRule("--", "--", (IToken)keyword));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new BetaWhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new BetaWordDetector(), (IToken)other);
        int i = 0;
        while (i < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i], (IToken)keyword);
            ++i;
        }
        i = 0;
        while (i < fgTypes.length) {
            wordRule.addWord(fgTypes[i], (IToken)type);
            ++i;
        }
        i = 0;
        while (i < fgConstants.length) {
            wordRule.addWord(fgConstants[i], (IToken)type);
            ++i;
        }
        rules.add(wordRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    public int read() {
        int result = super.read();
        if (result >= 65 && result <= 90) {
            result += 32;
        }
        return result;
    }
}

