/*
 * Decompiled with CFR 0.152.
 */
package daimi.ui.launching;

import daimi.util.Communicator;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BetaLaunchTab
extends AbstractLaunchConfigurationTab {
    private Text fArgs;
    private Text fFilename;
    private Text fMainType;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout workingDirLayout = new GridLayout();
        workingDirLayout.numColumns = 3;
        workingDirLayout.marginHeight = 0;
        workingDirLayout.marginWidth = 0;
        composite.setLayout((Layout)workingDirLayout);
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        composite.setFont(font);
        this.setControl((Control)composite);
        this.createVerticalSpacer(composite, 3);
        this.createVerticalSpacer(composite, 3);
        Label label = new Label(composite, 0);
        label.setText("Main Type");
        gd = new GridData(32);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        label.setFont(font);
        this.fMainType = new Text(composite, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fMainType.setLayoutData((Object)gd);
        this.fMainType.setFont(font);
        this.fMainType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                BetaLaunchTab.this.updateLaunchConfigurationDialog();
            }
        });
        label = new Label(composite, 0);
        label.setText("Main File Name");
        gd = new GridData(32);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        label.setFont(font);
        this.fFilename = new Text(composite, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fFilename.setLayoutData((Object)gd);
        this.fFilename.setFont(font);
        this.fFilename.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                BetaLaunchTab.this.updateLaunchConfigurationDialog();
            }
        });
        label = new Label(composite, 0);
        label.setText("VM arguments");
        gd = new GridData(32);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        label.setFont(font);
        this.fArgs = new Text(composite, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fArgs.setLayoutData((Object)gd);
        this.fArgs.setFont(font);
        this.fArgs.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                BetaLaunchTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public boolean isValid(ILaunchConfiguration config) {
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.fMainType.getText());
        Communicator.getC().path = new Path(this.fFilename.getText());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, this.fArgs.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, Communicator.CLASSPATH_PROVIDER);
        String name = Communicator.getC().theEditor.getTitle();
        Path path = new Path(Communicator.getC().getFile().getLocation().toOSString());
        path = path.removeLastSegments(1);
        path = path.append("jvm").append(String.valueOf(name.substring(0, name.length() - 3)) + "jar");
        Communicator.getC().path = path;
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, Communicator.DEFAULT_MAIN_TYPE);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            this.fMainType.setText(config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, ""));
        }
        catch (Exception exception) {}
        try {
            this.fArgs.setText(config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, ""));
        }
        catch (Exception exception) {}
        try {
            String name = Communicator.getC().theEditor.getTitle();
            Path path = new Path(Communicator.getC().getFile().getLocation().toOSString());
            path = path.removeLastSegments(1);
            path = path.append("jvm").append(String.valueOf(name.substring(0, name.length() - 3)) + "jar");
            Communicator.getC().path = path;
            this.fFilename.setText(Communicator.getC().path.toOSString());
        }
        catch (Exception exception) {}
    }

    public String getName() {
        return "BetaLaunchTab";
    }

    public Image getImage() {
        return null;
    }

    public void dispose() {
    }
}

