/*
 * Decompiled with CFR 0.152.
 */
package daimi.ui.betaeditor;

import beta.BetaAutoIndentStrategy;
import daimi.ui.betaeditor.BetaAnnotationHover;
import daimi.ui.betaeditor.BetaEditorEnvironment;
import daimi.ui.betaeditor.BetaTextHover;
import daimi.util.BetaColorProvider;
import daimi.util.BetaDoubleClickSelector;
import org.eclipse.jface.text.IAutoIndentStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.RGB;

public class BetaSourceViewerConfiguration
extends SourceViewerConfiguration {
    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new BetaAnnotationHover();
    }

    public IAutoIndentStrategy getAutoIndentStrategy(ISourceViewer sourceViewer, String contentType) {
        return new BetaAutoIndentStrategy();
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__beta_multiline_comment"};
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.setProposalPopupOrientation(10);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setContextInformationPopupBackground(BetaEditorEnvironment.getBetaColorProvider().getColor(new RGB(150, 150, 0)));
        return assistant;
    }

    public String getDefaultPrefix(ISourceViewer sourceViewer, String contentType) {
        return "__dftl_partition_content_type".equals(contentType) ? "//" : null;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new BetaDoubleClickSelector();
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"\t", "    "};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        BetaColorProvider provider = BetaEditorEnvironment.getBetaColorProvider();
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)BetaEditorEnvironment.getBetaCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(provider.getColor(BetaColorProvider.COMMENT))));
        reconciler.setDamager((IPresentationDamager)dr, "__beta_multiline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__beta_multiline_comment");
        return reconciler;
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return 1;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new BetaTextHover();
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute attribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)attribute));
        }
    }
}

