/*
 * Decompiled with CFR 0.152.
 */
package daimi.ui.betaeditor;

import beta.BetaInterface;
import daimi.ui.betaeditor.BetaContentOutlinePage;
import daimi.ui.betaeditor.BetaEditorEnvironment;
import daimi.ui.betaeditor.BetaEditorMessages;
import daimi.ui.betaeditor.BetaSourceViewerConfiguration;
import daimi.util.Communicator;
import daimi.util.CompileOutputParser;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.internal.ui.views.console.ConsoleView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.TextOperationAction;

public class BetaEditor
extends TextEditor {
    public BetaInterface betaenv;
    private BetaContentOutlinePage fOutlinePage;
    public ConsoleView cv = null;
    public String BETALIB = null;
    public boolean link_with_console = false;
    static /* synthetic */ Class class$0;

    public int getCursorPos() {
        return this.getSourceViewer().getSelectedRange().x;
    }

    public IDocument getDocument() {
        return this.getSourceViewer().getDocument();
    }

    public BetaEditor() {
        Communicator.getC().theEditor = this;
        IProject p = null;
        this.betaenv = new BetaInterface();
        String[] list = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().list();
        String local = null;
        int j = 0;
        while (j < list.length) {
            if (list[j].indexOf("betalib") >= 0) {
                this.BETALIB = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
                this.BETALIB = String.valueOf(this.BETALIB) + '\\' + list[j];
                local = list[j];
            }
            ++j;
        }
        if (this.BETALIB == null) {
            System.err.println("Couldn't find BETALIB!");
            System.err.println("Make sure your BETA system is installed in:");
            System.err.println(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        }
        try {
            p = ResourcesPlugin.getWorkspace().getRoot().getProject(local);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (!p.exists()) {
                p.create(null);
            }
            if (!p.isOpen()) {
                p.open(null);
            }
        }
        catch (Exception e) {
            System.out.println("Opening BetaLib Failed");
            e.printStackTrace();
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
    }

    public void ParseAndMarkOutput(IDocument doc) {
        this.removeMarkers();
        CompileOutputParser cop = new CompileOutputParser();
        cop.parse(doc);
        while (cop.hasMoreErrors()) {
            cop.getNext();
            this.createMarker(cop.getFilename(), cop.getMessage(), cop.getLineNo());
        }
    }

    private void createMarker(String name, String msg, int lineNo) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        System.out.println(name);
        IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(name));
        attributes.put("severity", new Integer(2));
        attributes.put("location", resource.getLocation().toString());
        attributes.put("lineNumber", new Integer(lineNo));
        attributes.put("message", msg);
        try {
            MarkerUtilities.createMarker((IResource)resource, attributes, (String)"org.eclipse.core.resources.problemmarker");
        }
        catch (CoreException coreException) {}
    }

    public void removeMarkers() {
        try {
            IFile target = ((IFileEditorInput)this.getEditorInput()).getFile();
            IMarker[] markers = target.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            int i = 0;
            while (i < markers.length) {
                markers[i].delete();
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ISourceViewer viewer = super.createSourceViewer(parent, ruler, styles);
        return viewer;
    }

    protected void createActions() {
        super.createActions();
        this.setAction("ContentAssistProposal", (IAction)new TextOperationAction(BetaEditorMessages.getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this, 13));
        this.setAction("ContentAssistTip", (IAction)new TextOperationAction(BetaEditorMessages.getResourceBundle(), "ContentAssistTip.", (ITextEditor)this, 14));
    }

    public void dispose() {
        BetaEditorEnvironment.disconnect((Object)this);
        if (this.fOutlinePage != null) {
            this.fOutlinePage.setInput(null);
        }
        super.dispose();
    }

    public void doRevertToSaved() {
        super.doRevertToSaved();
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void doSaveAs() {
        super.doSaveAs();
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (this.fOutlinePage != null) {
            this.fOutlinePage.setInput(input);
        }
    }

    public void editorContextMenuAboutToShow(MenuManager menu) {
        super.editorContextMenuAboutToShow((IMenuManager)menu);
        this.addAction((IMenuManager)menu, "ContentAssistProposal");
        this.addAction((IMenuManager)menu, "ContentAssistTip");
    }

    public Object getAdapter(Class required) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = new BetaContentOutlinePage(this.getDocumentProvider(), (ITextEditor)this);
                if (this.getEditorInput() != null) {
                    this.fOutlinePage.setInput(this.getEditorInput());
                }
            }
            return this.fOutlinePage;
        }
        return super.getAdapter(required);
    }

    protected void initializeEditor() {
        BetaEditorEnvironment.connect((Object)this);
        this.setSourceViewerConfiguration(new BetaSourceViewerConfiguration());
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.setEditorContextMenuId("#BetaEditorContext");
        this.setRulerContextMenuId("#BetaRulerContext");
    }
}

