/*
 * Decompiled with CFR 0.152.
 */
package daimi.ui.betaeditor;

import daimi.ui.betaeditor.BetaEditor;
import daimi.util.ReaderWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class BetaContentOutlinePage
extends ContentOutlinePage {
    protected Container root;
    protected IDocumentProvider fDocumentProvider;
    protected ITextEditor fTextEditor;
    protected Object fInput;

    public BetaContentOutlinePage(IDocumentProvider provider, ITextEditor editor) {
        this.fDocumentProvider = provider;
        this.fTextEditor = editor;
        this.root = new Container(null, null, null);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new ContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.root == null) {
            this.root = new Container(null, null, null);
        }
        if (this.fInput != null) {
            viewer.setInput(this.fInput);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.fTextEditor.resetHighlightRange();
        } else {
            Element element = (Element)((IStructuredSelection)selection).getFirstElement();
            if (element.position == null) {
                try {
                    IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(element.filename));
                    if (!resource.exists()) {
                        throw new Exception("File not editable");
                    }
                    ReaderWriter.getRW().back.add(((IFileEditorInput)this.fTextEditor.getEditorInput()).getFile().getLocation().toOSString());
                    this.fTextEditor.getEditorSite().getPage().openEditor(resource);
                }
                catch (Exception e) {
                    ReaderWriter.getRW().insertString("Couldn't open the file: " + element.filename);
                    ReaderWriter.getRW().insertString(e.toString());
                    ReaderWriter.getRW().write();
                    ReaderWriter.getRW().write();
                }
            } else {
                int start = element.position.getOffset();
                int length = element.position.getLength();
                try {
                    this.fTextEditor.setHighlightRange(start, length, true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.fTextEditor.resetHighlightRange();
                }
            }
        }
    }

    public void setInput(Object input) {
        this.fInput = input;
        this.update();
    }

    public void update() {
        Control control;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.setRedraw(false);
            viewer.setInput(this.fInput);
            control.setRedraw(true);
        }
    }

    protected class Element {
        protected Element father;
        public String name;
        public Position position;
        public String filename;

        public Element(Element father, String name, Position position) {
            this.father = father;
            this.name = name;
            this.position = position;
        }

        public String toString() {
            return this.name;
        }

        public void clear() {
        }
    }

    protected class Container
    extends Element {
        protected List children = new ArrayList();

        public Container(Element father, String name, Position position) {
            super(father, name, position);
        }

        public List getChildren() {
            return this.children;
        }

        public void clear() {
            ListIterator li = this.children.listIterator();
            while (li.hasNext()) {
                ((Element)li.next()).clear();
            }
            this.children.clear();
        }

        public void add(Element child) {
            this.children.add(child);
        }
    }

    protected class ContentProvider
    implements ITreeContentProvider {
        protected static final String SEGMENTS = "__beta_segments";
        protected IPositionUpdater fPositionUpdater = new DefaultPositionUpdater("__beta_segments");
        private TreeViewer viewer;

        protected ContentProvider() {
        }

        protected void parse(IDocument document) {
            int lines = document.getNumberOfLines();
            int offset = 0;
            int length = 0;
            int beginOffset = 0;
            boolean fragment = true;
            String theLine = null;
            String name = null;
            Container fragment_container = new Container(BetaContentOutlinePage.this.root, "Fragment Links", null);
            int line = 0;
            while (line < lines) {
                try {
                    length = document.getLineLength(line);
                    theLine = document.get(offset, length);
                }
                catch (BadLocationException badLocationException) {}
                offset += length;
                if (theLine.length() > 4) {
                    if (theLine.substring(0, 2).equals("--")) {
                        Position p = null;
                        try {
                            p = new Position(beginOffset, document.getLineOffset(line) - beginOffset);
                            document.addPosition(SEGMENTS, p);
                        }
                        catch (BadPositionCategoryException badPositionCategoryException) {
                        }
                        catch (BadLocationException badLocationException) {}
                        if (fragment && fragment_container != null) {
                            fragment = false;
                            fragment_container.position = p;
                            BetaContentOutlinePage.this.root.add(fragment_container);
                        } else {
                            BetaContentOutlinePage.this.root.add(new Element(BetaContentOutlinePage.this.root, name, p));
                        }
                        try {
                            beginOffset = document.getLineOffset(line);
                            name = theLine.substring(2, theLine.length() - 4);
                        }
                        catch (BadLocationException badLocationException) {}
                    } else if (fragment) {
                        int inx = theLine.indexOf(39) + 1;
                        int inx2 = -1;
                        if (inx > 0) {
                            inx2 = theLine.indexOf(39, inx);
                        }
                        if (inx > 0 && inx2 > 0) {
                            Element e = new Element(fragment_container, theLine.substring(0, inx2 + 1), null);
                            fragment_container.add(e);
                            e.filename = this.fragmentLink(theLine.substring(inx, inx2));
                        }
                    }
                }
                ++line;
            }
            try {
                if (fragment) {
                    BetaContentOutlinePage.this.root = new Container(null, "Fragment Links", null);
                }
                Position p = new Position(beginOffset, document.getLength() - beginOffset);
                document.addPosition(SEGMENTS, p);
                if (name == null) {
                    BetaContentOutlinePage.this.root.add(new Element(BetaContentOutlinePage.this.root, "Fragment Links", p));
                } else {
                    BetaContentOutlinePage.this.root.add(new Element(BetaContentOutlinePage.this.root, name, p));
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
            }
            catch (BadLocationException badLocationException) {}
        }

        private String fragmentLink(String file) {
            String filename = null;
            int i = file.indexOf("~beta");
            if (i >= 0) {
                BetaEditor editor = (BetaEditor)BetaContentOutlinePage.this.fTextEditor;
                filename = String.valueOf(editor.BETALIB) + file.substring(5);
            } else {
                String s = ((IFileEditorInput)BetaContentOutlinePage.this.fTextEditor.getEditorInput()).getFile().getLocation().toOSString();
                filename = new Path(s.substring(0, s.lastIndexOf(92) + 1)).append(file).toOSString();
            }
            if (filename.indexOf(".bet") < 0) {
                filename = String.valueOf(filename) + ".bet";
            }
            return filename;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            IDocument document;
            if (oldInput != null && (document = BetaContentOutlinePage.this.fDocumentProvider.getDocument(oldInput)) != null) {
                try {
                    document.removePositionCategory(SEGMENTS);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
                document.removePositionUpdater(this.fPositionUpdater);
            }
            BetaContentOutlinePage.this.root.clear();
            BetaContentOutlinePage.this.root = new Container(null, null, null);
            if (newInput != null && (document = BetaContentOutlinePage.this.fDocumentProvider.getDocument(newInput)) != null) {
                document.addPositionCategory(SEGMENTS);
                document.addPositionUpdater(this.fPositionUpdater);
                this.parse(document);
            }
        }

        public void dispose() {
            BetaContentOutlinePage.this.root.clear();
            BetaContentOutlinePage.this.root = null;
        }

        public boolean isDeleted(Object element) {
            return false;
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Container) {
                return ((Container)element).getChildren().size() > 0;
            }
            return false;
        }

        public Object getParent(Object element) {
            if (element instanceof Element) {
                return ((Element)element).father;
            }
            return null;
        }

        public Object[] getChildren(Object element) {
            if (element == BetaContentOutlinePage.this.fInput) {
                return BetaContentOutlinePage.this.root.getChildren().toArray();
            }
            if (element instanceof Container) {
                Container c = (Container)element;
                return c.getChildren().toArray();
            }
            return new Object[0];
        }
    }
}

